// Function to fetch API data
function fetchApiData() {
  return fetch('https://data.opendatasoft.com/api/explore/v2.1/catalog/datasets/brisbane-food-trucks@prod-brisbane-queensland/records?limit=20')
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not ok');
      }
      return response.json();
    })
    .catch(error => {
      console.error('Error fetching API data:', error);
    });
}

// Function to update the UI with filtered data
function updateUI(data) {
  const container = document.getElementById('data-container');
  container.innerHTML = ''; // Clear previous results

  const table = document.createElement('table');
  table.className = 'data-table';

  // Assuming data is an array of objects with id, category, name, and details properties
  const headers = ['ID', 'Category', 'Truck Name', 'Details'];
  const headerRow = table.insertRow();
  headers.forEach(headerText => {
    const headerCell = document.createElement('th');
    headerCell.textContent = headerText;
    headerRow.appendChild(headerCell);
  });

  data.forEach(item => {
    const row = table.insertRow();
    headers.forEach(header => {
      const cell = row.insertCell();
      cell.textContent = item[header.toLowerCase().replace(' ', '_')];
    });
  });

  container.appendChild(table);
}

// Function to filter API data based on the selected category or truck name
function filterApiData(filterType, filterValue) {
  fetchApiData().then(apiData => {
    if (!apiData) return;

    let filteredData;
    if (filterType === 'category') {
      filteredData = apiData.records.filter(item => item.fields.category === 'category');
    } else if (filterType === 'name') {
      filteredData = apiData.records.filter(item => item.fields.name === 'name');
    }

    updateUI(filteredData);
  });
}

// Event listeners for the radio buttons
document.addEventListener('DOMContentLoaded', () => {
  document.querySelector('.category-filter').addEventListener('change', event => {
    if (event.target.checked) {
      filterApiData('category', event.target.value);
    }
  });

  document.querySelector('.name-filter').addEventListener('change', event => {
    if (event.target.checked) {
      filterApiData('name', event.target.value);
    }
  });
});
